package gov.va.med.mhv.health.repository;

import gov.va.med.mhv.health.model.MilitaryHistory;

import java.util.List;

import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface MilitaryHistoryRepository extends JpaRepository<MilitaryHistory, Long> {
	
	
    @Query("select a from MilitaryHistory a where a.userprofileId = :userprofileid order by a.eventDate desc")
	 List<MilitaryHistory>  getMilitaryHistoryForUser(@Param ("userprofileid") Long userprofileid);
    
}
